import { Link, useLocation } from 'react-router-dom'
import { Scissors } from 'lucide-react'
import Footer from './Footer'
import './Layout.css'

const Layout = ({ children }) => {
  const location = useLocation()

  return (
    <div className="app-wrapper-modern">
      <header className="header-modern">
        <div className="container">
          <div className="header-content-modern">
            <Link to="/" className="logo-modern">
              <div className="logo-icon-wrapper-modern">
                <Scissors className="logo-icon-modern" size={28} />
              </div>
              <span className="logo-text-modern">SEWLAB</span>
            </Link>
            <nav className="nav-modern">
              <Link 
                to="/" 
                className={`nav-link-modern ${location.pathname === '/' ? 'active' : ''}`}
              >
                Мои курсы
              </Link>
              <Link 
                to="/enroll" 
                className={`nav-link-modern ${location.pathname === '/enroll' ? 'active' : ''}`}
              >
                Записаться
              </Link>
            </nav>
          </div>
        </div>
      </header>

      <main className="main-content-modern">
        {children}
      </main>

      <Footer />
    </div>
  )
}

export default Layout

